package newstate.tools;

import com.ibm.xml.parser.*;
import org.w3c.dom.*;
import java.io.*;
import newstate.*;

public class FSMGenerator
{
        public static FSMAction skip = new FSMAction() {
                public void execute(FSMContext fsmc, Object data)
                {
                }
        };
                
        public static Element parse(String filename)
        {
                if (filename != null) 
                {
                        InputStream is;
                        try 
                        {
                                is = new FileInputStream(filename);
                        } 
                        catch (FileNotFoundException notFound) 
                        {
                                System.err.println(notFound);
                                return null;
                        }
                        Document doc = new Parser(filename).readStream(is);
                        Element root = (Element)doc.getDocumentElement();                        
                        return root;
                 }
                return null;
        }
        
        public static void declareStates(Element root, FSM fsm)        
        {              
                NodeList nl = root.getElementsByTagName("state");
                for(int i = 0 ;  i < nl.getLength(); i++)
                {
                        createState((Element)nl.item(i), fsm);
                }

        }
        
        public static void createState(Element state, FSM fsm)
        {
                try {
                        String name = state.getAttribute("name");

                        String initaction = state.getAttribute("initaction");
                        FSMAction init = 
                                (FSMAction)Serializer.deserialize(initaction);

                        String exitaction = state.getAttribute("exitaction");
                        FSMAction exit = 
                                (FSMAction)Serializer.deserialize(exitaction);
                        if(init != null && exit != null)
                        {
                                fsm.addState(init,name,exit);
                        }
                        else if(init != null)
                        {
                                fsm.addState(init,name);
                        }
                        else if(exit != null)
                        {
                                fsm.addState(name,exit);
                        }
                        else
                        {
                                fsm.addState(name);
                        }
                } 
                catch(Exception e) 
                { 
                        e.printStackTrace(); 
                }
        }

        public static void declareEvents(Element root, FSM fsm)        
        {
                NodeList nl = root.getElementsByTagName("event");
                for(int i = 0 ;  i < nl.getLength(); i++)
                {
                        createEvent((Element)nl.item(i), fsm);
                }
        }

        public static void createEvent(Element event, FSM fsm)
        {
                try {
                String eventname = event.getAttribute("name");
                fsm.addEvent(eventname);
                } catch(Exception e) { e.printStackTrace(); }
        }

        public static void declareTransitions(Element root, FSM fsm)        
        {
                NodeList nl = root.getElementsByTagName("transition");
                for(int i = 0 ;  i < nl.getLength(); i++)
                {
                        createTransition((Element)nl.item(i), fsm);
                }
        }
        
        public static void createTransition(Element transition, FSM fsm)
        {
                try {
                String sourcestate = transition.getAttribute("sourcestate");
                String targetstate = transition.getAttribute("targetstate");
                String event = transition.getAttribute("event");
                String action = transition.getAttribute("action");
                FSMAction fsmaction = 
                        (FSMAction)Serializer.deserialize(action);
                if(action == null)
                        fsm.addTransition(sourcestate, 
                                          event, 
                                          targetstate, 
                                          skip);
                else
                        fsm.addTransition(sourcestate, 
                                          event, 
                                          targetstate, 
                                          fsmaction);
                } catch(Exception e) { e.printStackTrace(); }
        }
        
        
        public static FSM generateFSM(String filename)
        {
                FSM fsm = new FSM();
                Element root = parse(filename);
                declareStates(root, fsm);
                declareEvents(root, fsm);
                declareTransitions(root, fsm);
                fsm.setFirstState(root.getAttribute("firststate"));
                String initaction = root.getAttribute("initaction");
                if(initaction != null)
                {
                        try{
                                fsm.setInitAction(
                                    (FSMAction)Serializer.deserialize(initaction));
                        } catch(Exception e) {}
                }
                return fsm;
        }                
}